﻿dynamic class Card1 extends MovieClip
	{
	private var m_nID:Number=0;
	private var m_nType:Number=0; //1=graphic, 2=text
	private var m_Content:String;
	private var m_bContentChanged:Boolean=false;
	private var m_nTurnTarget:Number=0; //1=up, 2=down
	private var m_bFadingOut:Boolean;
	private var m_bLocked:Boolean=false;
	private var m_fltGlow:flash.filters.GlowFilter;
	private var m_nFlashTimes:Number=0;
	private var m_Flashed:Number=0;

	//Methods
	function SetID(n:Number) { m_nID=n };
	function GetID():Number { return m_nID; }
	function GetType():Number { return m_nType; }
	function SetContent(nType:Number,sContent:String) { m_nType=nType; m_Content=sContent; m_bContentChanged=true; }
	function SetLock(b:Boolean) { m_bLocked=b; }
	function IsLocked():Boolean { return m_bLocked; }

	function SetGlow(nColor:Number) //nColor=0 removes glow
		{
		if (nColor==0) //remove glow
			{
			this.filters=[];
			if (m_fltGlow!=undefined)
				{
				delete m_fltGlow;
				m_fltGlow=undefined;
				}
			}
		else //set glow
			{
			m_fltGlow=new flash.filters.GlowFilter(nColor,0.80,16,16,3,3,false,false);
			this.filters=[m_fltGlow];
			}
		}

	function Flash() { m_nFlashTimes=8; m_Flashed=1;}

	function IsTurnedUp():Boolean { return (((this._currentframe==1) || (m_nTurnTarget==1))?true:false); }
	function IsTurnedDown():Boolean { return (!IsTurnedUp()); }
	function IsTurning():Boolean { return ((m_nTurnTarget!=0)?true:false); }
	function IsMatching(c:Card1) { return (((m_nType!=c.GetType()) && (m_nID==c.GetID()))?true:false); }

	private function PrepareTurn(nSide:Number)
		{
		if (this._currentframe==nSide)
			return;
		m_nTurnTarget=nSide;
		m_bFadingOut=true;
		}
	function TurnUp(bEffect:Boolean)
		{
		if (bEffect)
			PrepareTurn(1);
		else
			this.gotoAndStop(1);
		}
	function TurnDown(bEffect:Boolean)
		{
		if (bEffect)
			PrepareTurn(2);
		else
			this.gotoAndStop(2);
		}

	//Handlers
	function onEnterFrame()
		{
		//content update
		if (m_bContentChanged)
			{
			if (m_nType==1) //graphic
				{
				this.txtText._visible=false;
				this.imgContent._visible=true;
				this.txtText.text="";
				this.imgContent.contentPath=m_Content;
				}
			else
			if (m_nType==2) //text
				{
				this.txtText._visible=true;
				this.imgContent._visible=false;
				this.txtText.text=m_Content;
				this.imgContent.contentPath="";
				}
			else //clear
				{
				this.txtText._visible=false;
				this.imgContent._visible=false;
				this.txtText.text="";
				this.imgContent.contentPath="";
				}
			m_bContentChanged=false;
			}

		//turn effect
		if (m_nTurnTarget!=0)
			{
			if (m_bFadingOut)
				{
				if (this._alpha>0)
					this._alpha-=20;
				else
					{
					m_bFadingOut=false;
					this.gotoAndStop(m_nTurnTarget);
					if (m_nTurnTarget==1)
						SetContent(m_nType,m_Content);
					}
				}
			else
				{
				if (this._alpha<100)
					this._alpha+=20;
				else
					{
					var bFaceUp:Boolean=((m_nTurnTarget==1)?true:false);
					m_nTurnTarget=0;
					//notify listeners for turn card animation completion
					this.broadcastMessage("CardTurnEnd",this,bFaceUp);
					}
				}
			}

		//flash effect
		if (m_nFlashTimes>0)
			{
			--m_nFlashTimes;
			this._visible=((m_nFlashTimes % 2)==0)?true:false;
			if (m_nFlashTimes==0)
				this.broadcastMessage("CardFlashEnd",this);
			}
		}
		
	}